/******************************************************************************
* (C) Copyright 2007 by Agilent Technologies, All Rights Reserved.
******************************************************************************/

#ifndef PCIEFPGACSDAT_H
#define PCIEFPGACSDAT_H

#include "AgtPCIPort.h"
#include "devpciedefs.h"

#define HOTACCESS_MEMSIZE_DW ( ( UInt32 ) 8 )

class CAgtPCIEControl;

class CPCIEFpgaCSDat
{
public:

  enum DataCmpStatus
  {
    RXDATAMEM_DATACMPSTATUS_INTADDR,
    RXDATAMEM_DATACMPSTATUS_REALDATA,
    RXDATAMEM_DATACMPSTATUS_EXPECTEDATA
  };

  enum RxDataMemCompCtrlBit
  {
    RXDATAMEM_MEMCOMPCTRL_ENABLE_DATA_COMPARE_BIT = 0,
    RXDATAMEM_MEMCOMPCTRL_RESET_COUNTERS_BIT      = 1,
    RXDATAMEM_MEMCOMPCTRL_REQUEST_SNAPSHOT_BIT    = 2
  };

  enum RxDataMemCompStatusBit
  {
    RXDATAMEM_MEMCOMPSTATUS_MISMATCH_FOUND_BIT      = 0,
    RXDATAMEM_MEMCOMPSTATUS_COMP_ERR_COUNT_WRAPPED  = 1,
    RXDATAMEM_MEMCOMPSTATUS_REF_COUNT_WRAPPED       = 2
  };

  // = FOUNDATION
  CPCIEFpgaCSDat( void );
  ~CPCIEFpgaCSDat( void );

  // = ACTION

  //
  // register wrappers
  //
  /*void setMemCompCtrl( const AgtPortHandleT& portHandle, const UInt32& val );
  UInt32 getMemCompCtrl( const AgtPortHandleT& portHandle );
  void setMemCompStatus( const AgtPortHandleT& portHandle, const UInt32& val );
  UInt32 getMemCompStatus( const AgtPortHandleT& portHandle );
  UInt32 getMemCompErrCount( const AgtPortHandleT& portHandle );
  UInt32 getMemCompRefCount( const AgtPortHandleT& portHandle );
  UInt32 getMemCompActual( const AgtPortHandleT& portHandle );
  UInt32 getMemCompExpected( const AgtPortHandleT& portHandle );
  UInt32 getMemCompBEAddr( const AgtPortHandleT& portHandle );
  UInt8  getMemCompActualByte( const AgtPortHandleT& portHandle );
  UInt8  getMemCompExpectedByte( const AgtPortHandleT& portHandle );    
  UInt32 getMemCompErrorAddress( const AgtPortHandleT& portHandle );  
  UInt32 getMemCompMask( const AgtPortHandleT& portHandle );*/
  UInt32 getHotAccessDataBE( const AgtPortHandleT& portHandle );
  void setHotAccessDataBE( const AgtPortHandleT& portHandle, const UInt32& val );
  UInt32 getHotAccessControl( const AgtPortHandleT& portHandle );
  void setHotAccessControl( const AgtPortHandleT& portHandle, const UInt32& val );
  UInt32 getHotAccessStatus( const AgtPortHandleT& portHandle );

  //
  // functions
  //

  // former register wrapper
  UInt32 getData( const AgtPortHandleT& portHandle, const UInt32& idx );
  void setData( const AgtPortHandleT& portHandle, const UInt32& idx, const UInt32& val );

  bool compareData( const AgtPortHandleT& portHandle, const UInt32& offsetRealData, const UInt32& sizeDW,
    const UInt8& firstDWBE, const UInt8& lastDWBE );
  UInt32 getCompareDataStatus( const DataCmpStatus& status );
  void  writeData( const AgtPortHandleT& portHandle, const UInt32& address, const UInt32& numBytes,
    const UInt8* data, UInt32& vectorOffsetIndex );
  void readData( const AgtPortHandleT& portHandle, const UInt32& address, const UInt32& numBytes, UInt8* data,
    UInt32& vectorOffsetIndex );

  // Hot access data write
  void writeReadDataHotAccess( const AgtPortHandleT& portHandle, const UInt32& address, const UInt32& numBytes,
    UInt8* data, bool isWrite, AgtSizeT* pCount );

  void writeDataHotAccess( const AgtPortHandleT& portHandle, const UInt32& address, const UInt32& numBytes,
    const UInt8* data );
  void readDataHotAccess( const AgtPortHandleT& portHandle, const UInt32& address, const UInt32& numBytes,
    UInt8* data, AgtSizeT* pCount );

  /*bool getMemCompCtrlBit( const AgtPortHandleT& portHandle, const RxDataMemCompCtrlBit& theBit );
  void setMemCompCtrlBit( const AgtPortHandleT& portHandle, const RxDataMemCompCtrlBit& theBit, const bool& bVal );
  bool getMemCompStatusBit( const AgtPortHandleT& portHandle, const RxDataMemCompStatusBit& theBit );
  void setMemCompStatusBit( const AgtPortHandleT& portHandle, const RxDataMemCompStatusBit& theBit,
    const bool& bVal );*/

private:

  // Registers
  UInt32 mHotAccessControl;
  UInt32 mHotAccessDataBE;
  UInt32 mHotAccessStatus;
  UInt32 mHotAccessRdDDw0;
  UInt32 mHotAccessWrDDw0;

  /*UInt32 mMemCompCtrl;
  UInt32 mMemCompStatus;
  UInt32 mMemCompErrCount;
  UInt32 mMemCompRefCount;
  UInt32 mMemCompActual;
  UInt32 mMemCompExpected;
  UInt32 mMemCompBEAddr;*/

  // data compare 
  UInt32 mDataCmpIntAddr;
  UInt32 mDataCmpRealData;
  UInt32 mDataCmpExpectedData;

  // helper
  bool checkBytesAtDWOffset( const AgtPortHandleT& portHandle, const UInt32& offsetRealData,
    const UInt32& offsetExpectedData, const UInt32& mask );
  bool memCmp32( const AgtPortHandleT& portHandle, const UInt32& dwOffset1, const UInt32& dwOffset2,
    const UInt32& dwLen );

  UInt32 calculateMaskValueFromByteNum( UInt32 byteNum, UInt32 offset );

  void setBits( UInt32& val, const UInt8& bitPos, const UInt8& bitSize, const UInt32& bitVal );
  UInt32 getBits( const UInt32& val, const UInt8& bitPos, const UInt8& bitSize );
  UInt32 swapDW( const UInt32& val );

  CAgtPCIEControl* myController;
};

#endif /* PCIEFPGACSDAT_H */